% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_open}
\alias{repo_open}
\title{Open an existing repository or create a new one.}
\arguments{
\item{root}{Path to store data in. Defaults to "~/.R_repo".}

\item{force}{Don't ask for confirmation.}
}
\value{
An object of class \code{repo}.
}
\description{
If a repository does not exist at the specified location, creates a
directory and stores the repository index in it. If a repository
exists, the index is loaded and a \code{repo} object is built.
}
\examples{
## Creates a new repository in a temporary directory without asking for
## confirmation.
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(0, "zero", "a random item", "a_tag")
rp$info()
## wiping temporary repo
unlink(rp_path, TRUE)
}

