% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{mvsum}
\alias{mvsum}
\title{Get multivariate summary dataframe}
\usage{
mvsum(
  model,
  data,
  digits = getOption("reportRmd.digits", 2),
  showN = TRUE,
  showEvent = TRUE,
  markup = TRUE,
  sanitize = TRUE,
  nicenames = TRUE,
  CIwidth = 0.95,
  vif = TRUE
)
}
\arguments{
\item{model}{fitted model object}

\item{data}{dataframe containing data}

\item{digits}{number of digits to round to}

\item{showN}{boolean indicating sample sizes should be shown for each
comparison, can be useful for interactions}

\item{showEvent}{boolean indicating if number of events should be shown. Only
available for logistic.}

\item{markup}{boolean indicating if you want latex markup}

\item{sanitize}{boolean indicating if you want to sanitize all strings to not
break LaTeX}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space.}

\item{CIwidth}{width for confidence intervals, defaults to 0.95}

\item{vif}{boolean indicating if the variance inflation factor should be
included. See details}
}
\description{
Returns a dataframe with the model summary and global p-value for multi-level
variables.
}
\details{
Global p-values are likelihood ratio tests for lm, glm and polr models. For
lme models an attempt is made to re-fit the model using ML and if,successful
LRT is used to obtain a global p-value. For coxph models the model is re-run
without robust variances with and without each variable and a LRT is
presented. If unsuccessful a Wald p-value is returned. For GEE and CRR models
Wald global p-values are returned.

If the variance inflation factor is requested (VIF=T) then a generalised VIF
will be calculated in the same manner as the car package.

VIF for competing risk models is computed by fitting a linear model with a
dependent variable comprised of the sum of the model independent variables
and then calculating VIF from this linear model.
}
\references{
John Fox & Georges Monette (1992) Generalized Collinearity
Diagnostics, Journal of the American Statistical Association, 87:417,
178-183, DOI: 10.1080/01621459.1992.10475190

John Fox and Sanford Weisberg (2019). An {R} Companion to
Applied Regression, Third Edition. Thousand Oaks CA: Sage.
}
\keyword{dataframe}
