## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval=FALSE, echo=TRUE----------------------------------------------------
#  library(reporter)
#  
#  # Create temporary path
#  tmp <- file.path(tempdir(), "example5.txt")
#  
#  # Prepare Data
#  dat <- mtcars[1:10, ]
#  df <- data.frame(vehicle = rownames(dat), dat)
#  
#  # Define Table with spanning headers
#  tbl <- create_table(df) %>%
#    titles("Table 1.0", "MTCARS Spanning Headers") %>%
#    spanning_header(from = "mpg", to = "hp", label = "Span 1", n = 10) %>%
#    spanning_header(from = "drat", to = "qsec", label = "Span 2", n = 10) %>%
#    spanning_header(from = "vs", to = "carb", label = "Span 3", n = 10) %>%
#    spanning_header(from = "drat", to = "carb",
#                    label = "Super Span", level = 2) %>%
#    define(vehicle, label = "Vehicle") %>%
#    define(mpg, format = "%.1f") %>%
#    define(disp, visible = FALSE) %>%
#    define(am, visible = FALSE)
#  
#  # Create Report and add table
#  rpt <- create_report(tmp) %>%
#    add_content(tbl, align = "left")
#  
#  # Write the report
#  res <- write_report(rpt)
#  
#  # View in console
#  writeLines(readLines(tmp, encoding = "UTF-8"))
#  
#  #                              Table 1.0
#  #                       MTCARS Spanning Headers
#  #
#  #                                              Super Span
#  #                                   --------------------------------
#  #                        Span 1            Span 2          Span 3
#  #                        (N=10)            (N=10)          (N=10)
#  #                    -------------- ------------------- ------------
#  # Vehicle              mpg cyl   hp  drat     wt   qsec vs gear carb
#  # ------------------------------------------------------------------
#  # Mazda RX4           21.0   6  110   3.9   2.62  16.46  0    4    4
#  # Mazda RX4 Wag       21.0   6  110   3.9  2.875  17.02  0    4    4
#  # Datsun 710          22.8   4   93  3.85   2.32  18.61  1    4    1
#  # Hornet 4 Drive      21.4   6  110  3.08  3.215  19.44  1    3    1
#  # Hornet Sportabout   18.7   8  175  3.15   3.44  17.02  0    3    2
#  # Valiant             18.1   6  105  2.76   3.46  20.22  1    3    1
#  # Duster 360          14.3   8  245  3.21   3.57  15.84  0    3    4
#  # Merc 240D           24.4   4   62  3.69   3.19     20  1    4    2
#  # Merc 230            22.8   4   95  3.92   3.15   22.9  1    4    2
#  # Merc 280            19.2   6  123  3.92   3.44   18.3  1    4    4
#  
#  

