% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_style.R
\name{print.style_spec}
\alias{print.style_spec}
\title{Prints a style specification}
\usage{
\method{print}{style_spec}(x, ..., verbose = FALSE)
}
\arguments{
\item{x}{A style object to print.}

\item{...}{Any follow-on parameters to pass to print().}

\item{verbose}{If verbose is TRUE, the function will print the style
object as a list. Otherwise, the object will print using the custom
print function.  The custom print is more compact than the verbose style 
print. Default is FALSE.}
}
\description{
This function will print a style object to the console.  The print function
will display each style setting that has been assigned, and the value
which is assigned.
}
\examples{
library(reporter)

# Get theme
tm <- get_theme("SteelBlue")

# View theme settings
print(tm)
## A style specification: 
#- font_name: 'Arial'
#- font_size: 10
#- text_color: 'DimGrey'
#- title_font_size: 11
#- title_font_bold: TRUE
#- title_font_color: 'SteelBlue'
#- border_color: 'Grey'
#- table_header_background: 'SteelBlue'
#- table_header_font_bold: TRUE
#- table_header_font_color: 'LightGrey'
#- table_body_background: 'White'
#- table_body_stripe: 'WhiteSmoke'
#- table_stub_background: 'SteelBlue'
#- table_stub_font_color: 'LightGrey'
#- table_stub_font_bold: TRUE
}
\seealso{
Other styles: 
\code{\link{add_style}()},
\code{\link{create_style}()},
\code{\link{get_theme}()}
}
\concept{styles}
