% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{ftn}
\alias{ftn}
\title{Creates a footnote attribute}
\usage{
ftn(
  footnotes,
  align = "left",
  blank_row = "above",
  borders = "none",
  valign = NULL,
  width = NULL
)
}
\arguments{
\item{footnotes}{A vector of footnote strings.}

\item{align}{The position to align the footnotes.  Valid values are: 'left',
'right', 'center', or 'centre'.}

\item{blank_row}{Whether to print a blank row above or below the footnote.
Valid values are 'above', 'below', 'both', or 'none'.  Default is 'above'.}

\item{borders}{Whether to print a border above or below the footnote. Valid
values are 'top', 'bottom', 'outside', 'inside', 'all',  or 'none'.  
Default is 'none'.}

\item{valign}{The vertical position to align the footnotes.  Valid
values are: 'top' and 'bottom'.}

\item{width}{The width of the footnotes block.}
}
\value{
The footnote attribute object.
}
\description{
The \code{ftn} function creates a footnote attribute,
which may be attached as an attribute to a data frame and passed
into \code{\link{create_table}}. This function is used internally to
the system.
}
\seealso{
\code{\link{footnotes}} to create a footnote.

Other attributes: 
\code{\link{span}()},
\code{\link{ttl}()}
}
\concept{attributes}
