% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{CacheDigest}
\alias{CacheDigest}
\title{The exact digest function that \code{Cache} uses}
\usage{
CacheDigest(
  objsToDigest,
  ...,
  algo = "xxhash64",
  calledFrom = "CacheDigest",
  .functionName = NULL,
  quick = FALSE
)
}
\arguments{
\item{objsToDigest}{A list of all the objects (e.g., arguments) to be digested}

\item{...}{passed to \code{.robustDigest}.}

\item{algo}{The algorithms to be used; currently available choices are
    \code{md5}, which is also the default, \code{sha1}, \code{crc32},
    \code{sha256}, \code{sha512}, \code{xxhash32}, \code{xxhash64},
    \code{murmur32}, \code{spookyhash}, \code{blake3}, and \code{crc32c}.}

\item{calledFrom}{a Character string, length 1, with the function to
compare with. Default is "Cache". All other values may not produce
robust CacheDigest results.}

\item{.functionName}{A an arbitrary character string that provides a name that is different
than the actual function name (e.g., "rnorm") which will be used for messaging. This
can be useful when the actual function is not helpful for a user, such as \code{do.call}.}

\item{quick}{Logical or character. If \code{TRUE},
no disk-based information will be assessed, i.e., only
memory content. See Details section about \code{quick} in \code{\link[=Cache]{Cache()}}.}
}
\value{
A list of length 2 with the \code{outputHash}, which is the digest
that Cache uses for \code{cacheId} and also \code{preDigest}, which is
the digest of each sub-element in \code{objsToDigest}.
}
\description{
This can be used by a user to pre-test their arguments before running
\code{Cache}, for example to determine whether there is a cached copy.
}
\examples{
data.table::setDTthreads(2)
a <- Cache(rnorm, 1)

# like with Cache, user can pass function and args in a few ways
CacheDigest(rnorm(1)) # shows same cacheId as previous line
CacheDigest(rnorm, 1) # shows same cacheId as previous line

}
