% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{as.info}
\alias{info}
\title{Get information on an ERDDAP dataset.}
\usage{
info(datasetid, url = eurl(), ...)

as.info(x, url)
}
\arguments{
\item{datasetid}{Dataset id}

\item{url}{A URL for an ERDDAP server. Default: \url{http://upwell.pfeg.noaa.gov/erddap/}}

\item{...}{Further args passed on to \code{\link[httr]{GET}} (must be a named parameter)}

\item{x}{A datasetid or the output of \code{info}}
}
\value{
Prints a summary of the data on return, but you can index to various information.

The data is a list of length two with:
\itemize{
 \item variables - Data.frame of variables and their types
 \item alldata - List of data variables and their full attributes
}
Where \code{alldata} element has many data.frame's, one for each variable, with metadata
for that variable. E.g., for griddap dataset \code{noaa_pfeg_696e_ec99_6fa6}, \code{alldata}
has:
\itemize{
 \item NC_GLOBAL
 \item time
 \item latitude
 \item longitude
 \item sss
}
}
\description{
Get information on an ERDDAP dataset.
}
\examples{
\dontrun{
# grid dap datasets
info('noaa_esrl_027d_0fb5_5d38')

(out <- ed_search(query='temperature'))
info(out$info$dataset_id[5])
info(out$info$dataset_id[15])
info(out$info$dataset_id[25])
info(out$info$dataset_id[150])
info(out$info$dataset_id[400])
info(out$info$dataset_id[678])

out <- info(datasetid='noaa_esrl_027d_0fb5_5d38')
## See brief overview of the variables and range of possible values, if given
out$variables
## all information on longitude
out$alldata$longitude
## all information on air
out$alldata$air

# table dap datasets
(out <- ed_search(query='temperature', which = "table"))
info(out$info$dataset_id[1])
info(out$info$dataset_id[2])
info(out$info$dataset_id[3])
info(out$info$dataset_id[4])

info('erdCalCOFIfshsiz')
out <- info('erdCinpKfmBT')
## See brief overview of the variables and range of possible values, if given
out$variables
## all information on longitude
out$alldata$longitude
## all information on Haliotis_corrugata_Mean_Density
out$alldata$Haliotis_corrugata_Mean_Density

# use a different ERDDAP server
## Marine Institute (Ireland)
info("IMI_CONN_2D", url = "http://erddap.marine.ie/erddap/")
## Marine Domain Awareness (MDA) (Italy)
info("erdMH1chlamday", url = "https://bluehub.jrc.ec.europa.eu/erddap/")
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}

