% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mbl.R
\name{plot.mbl}
\alias{plot.mbl}
\title{Plot method for an object of class \code{mbl}}
\usage{
\method{plot}{mbl}(x, g = c("validation", "pca"), param = "rmse", pcs = c(1,2), ...)
}
\arguments{
\item{x}{an object of class \code{mbl} (as returned by \code{mbl}).}

\item{g}{a character \code{vector} indicating what results shall be plotted. Options are: "validation" (for plotting the validation results) and/or "pca" (for plotting the principal components).}

\item{param}{one of the following options "rmse", "st.rmse" or "r2". The respective validation statistic is then plotted. It is only available if \code{"validation"} is specified in the \code{g} argument.}

\item{pcs}{a vector of length one or two indicating the principal components to be plotted. Default is \code{c(1, 2)}. It is only available if \code{"pca"} is specified in the \code{g} argument.}

\item{...}{some arguments to be passed to methods as graphical parameters.}
}
\description{
Plots the content of an object of class \code{mbl}
}
\examples{
\dontrun{
require(prospectr)

data(NIRsoil)

Xu <- NIRsoil$spc[!as.logical(NIRsoil$train),]
Yu <- NIRsoil$CEC[!as.logical(NIRsoil$train)]
Yr <- NIRsoil$CEC[as.logical(NIRsoil$train)]
Xr <- NIRsoil$spc[as.logical(NIRsoil$train),]

Xu <- Xu[!is.na(Yu),]
Yu <- Yu[!is.na(Yu)]

Xr <- Xr[!is.na(Yr),]
Yr <- Yr[!is.na(Yr)] 

ctrl <- mblControl(sm = "cor", ws = 51, 
                   pcSelection = list("cumvar", 0.999), 
                   valMethod = c("NNv"), 
                   scaled = TRUE, center = TRUE)

ex1 <- mbl(Yr = Yr, Xr = Xr, Yu = NULL, Xu = Xu,
           mblCtrl = ctrl,
           dissUsage = "none", 
           k = seq(30, 250, 30), 
           method = "wapls1",
           plsC = c(7, 20))

plot(ex1)
}
}
\author{
Leonardo Ramirez-Lopez and Antoine Stevens
}
\seealso{
\code{\link{mbl}}
}

