test_that("gamma distribution works", {
  set.seed(1337L)
  dist <- dist_gamma()
  params <- list(shape = 2, rate = 3)
  x <- dist$sample(100L, with_params = params)

  expect_silent(fit(dist, x))
  expect_identical(dist$get_type(), "continuous")
  expect_density(dist, dgamma, params, x)
  expect_probability(dist, pgamma, params, x)
  expect_quantile(dist, qgamma, params)
  expect_identical(dist$is_in_support(x), rep_len(TRUE, length(x)))
  expect_diff_density(dist, x, params)
  expect_diff_density(dist, x, list(shape = 3, rate = 5))
  expect_diff_probability(dist, x, params)
  expect_diff_probability(dist, x, list(shape = 3, rate = 5))
  expect_tf_logdensity(dist, params, x)
  expect_tf_logprobability(dist, params, x, x + 1.0)
  expect_tf_logprobability(dist, params, 0.0, x)
  expect_tf_logprobability(dist, params, x, Inf)

  expect_tf_fit(dist, params, I_POSITIVE_REALS)
})
