% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape.R
\name{make_landscape}
\alias{make_landscape}
\title{Landscape initialisation}
\usage{
make_landscape(
  terrain = NA,
  rows = NA,
  cols = NA,
  depth = 21,
  farms = 4,
  public_land = 0,
  farm_var = 0
)
}
\arguments{
\item{terrain}{a layer of terrain that can be added to specify farm position}

\item{rows}{The dimension of the other side of the landscape (e.g., Longitude)}

\item{cols}{The dimension of one side of the landscape (e.g., Latitude)}

\item{depth}{The number of layers in the 3D landscape}

\item{farms}{The number of farms on the landscape}

\item{public_land}{The proportion of landscape cells that are not farmland}

\item{farm_var}{Does the land distribution vary among farms (>=0, <1)}
}
\value{
the_land A cols by rows landscape with randomly distributed cell types
}
\description{
Initialise the landscape for a simulation. This should not normally need to 
be done explicitly with this function because it is run inside of the 
run_farm_sim function, but this gives the option to generate a landscape 
without actually running a simulation. All landscapes are produced as three
dimensional arrays with varying numbers of rows and columns that determine
landscape size, and a depth of 21 layers. The top layer defines which cells
belong to which farm, while the remaining layers define how much of a given
crop is on the landscape cell (2-11) or how much pesticide has been applied
to it (12-21). An arbitrary number of farms are placed in a blocked design 
on the landscape using a shortest split-line algorithm, which attempts to 
make farm size as even as possible. Specifying public land is possible, and
adds sections of land that are not farms, but this is not recommended.
}
\examples{
land <- make_landscape(rows = 10, cols = 10, depth = 2, farms = 4)
}
