% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBIResourceConnector.R
\docType{class}
\name{DBIResourceConnector}
\alias{DBIResourceConnector}
\title{DBI resource connector}
\format{
A R6 object of class DBIResourceConnector
}
\description{
DBI resource connector

DBI resource connector
}
\details{
Makes a DBI connection from a resource description, used in SQLResourceClient that is based on DBI.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DBIResourceConnector$new()}}
\item \href{#method-isFor}{\code{DBIResourceConnector$isFor()}}
\item \href{#method-createDBIConnection}{\code{DBIResourceConnector$createDBIConnection()}}
\item \href{#method-getTableName}{\code{DBIResourceConnector$getTableName()}}
\item \href{#method-readDBTable}{\code{DBIResourceConnector$readDBTable()}}
\item \href{#method-readDBTibble}{\code{DBIResourceConnector$readDBTibble()}}
\item \href{#method-closeDBIConnection}{\code{DBIResourceConnector$closeDBIConnection()}}
\item \href{#method-clone}{\code{DBIResourceConnector$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new DBIResourceConnector instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A DBIResourceConnector object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isFor"></a>}}
\if{latex}{\out{\hypertarget{method-isFor}{}}}
\subsection{Method \code{isFor()}}{
Check that the provided parameter is of class "resource".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$isFor(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{The resource object to validate.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createDBIConnection"></a>}}
\if{latex}{\out{\hypertarget{method-createDBIConnection}{}}}
\subsection{Method \code{createDBIConnection()}}{
Stub function which subclasses will implement to create a DBI connection object from a resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$createDBIConnection(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTableName"></a>}}
\if{latex}{\out{\hypertarget{method-getTableName}{}}}
\subsection{Method \code{getTableName()}}{
Get the SQL table name from the resource URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$getTableName(resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The SQL table name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-readDBTable"></a>}}
\if{latex}{\out{\hypertarget{method-readDBTable}{}}}
\subsection{Method \code{readDBTable()}}{
Read a table as a vanilla tibble using DBI connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$readDBTable(conn, resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A DBI connection object.}

\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vanilla tibble.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-readDBTibble"></a>}}
\if{latex}{\out{\hypertarget{method-readDBTibble}{}}}
\subsection{Method \code{readDBTibble()}}{
Read a table as a SQL tibble using DBI connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$readDBTibble(conn, resource)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A DBI connection object.}

\item{\code{resource}}{A valid resource object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A SQL tibble.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-closeDBIConnection"></a>}}
\if{latex}{\out{\hypertarget{method-closeDBIConnection}{}}}
\subsection{Method \code{closeDBIConnection()}}{
Disconnect the DBI connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$closeDBIConnection(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A DBI connection object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DBIResourceConnector$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
