% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_by_temp.R
\encoding{UTF-8}
\name{adj_by_temp}
\alias{adj_by_temp}
\title{Predict biological parameters at a new temperature}
\usage{
adj_by_temp(
  meas_temp,
  meas_x,
  temp_new,
  method = "Q10",
  Q10,
  E,
  show_coef = FALSE,
  plot_fit = TRUE
)
}
\arguments{
\item{meas_temp}{a vector of temperature values (°C) corresponding to \code{meas_x}.}

\item{meas_x}{a vector of biological values (e.g. MO2, Pcrit) corresponding to \code{meas_temp}. These are typically empirically derived.}

\item{temp_new}{a vector of temperature values (°C) at which new values of "x" should be predicted.}

\item{method}{which method for calculcating temperature-dependency should be used? Options are "Q10" (default) and "E". If either \code{Q10} or \code{E} parameters have values, then this parameter is ignored.}

\item{Q10}{(optional). A Q10 value to be used for predicting new values of "x". If \code{method = "Q10"} and Q10 is not defined here, then an appropriate Q10 value will be calculated internally using \code{\link{Q10}}.}

\item{E}{(optional). An E value to be used for predicting new values of "x". If \code{method = "E"} and E is not defined here, then an appropriate E value will be calculated internally using \code{\link{calc_E}}.}

\item{show_coef}{logical. Should the temperature-dependency coefficient (i.e. the numeric value of either Q10 or E) be returned alongside the new values of "x"? Default is \code{FALSE}.}

\item{plot_fit}{logical. Should a plot be displayed showing how well the new "x" values fit with the inputted data? Default is \code{TRUE}.}
}
\value{
If \code{show_coef = FALSE} (default), then a numeric vector of new values of "x" are returned.
If \code{show_coef = TRUE}, then a list of new values and the temperature-dependency coefficient are returned.
}
\description{
Predicts the values of any inputted biological parameter (e.g. MO2, Pcrit) at a new temperature based on empirical measurements at a range of temperatures. Data can be fit to a temperature-dependence curve using either \code{\link{Q10}} or \code{\link{calc_E}}. By default, the predicted values are also plotted alongside the inputted data to allow the user to assess the quality of the fit.
}
\examples{
# I measured Pcrit at four different temperatures. What is the Pcrit at an
# intermediate temperature?
adj_by_temp(meas_temp = c(5, 10, 15, 20), meas_x = c(3.1, 6.3, 7, 8.4), temp_new = 18)

# If requested values exceed the inputted temperature range, a message is reported.
# Biology cannot go on forever like the math can.
adj_by_temp(meas_temp = c(10, 15, 20, 25), meas_x = c(4.8, 6, 12.3, 13.6), temp_new = 0:30)

}
\seealso{
\code{\link{Q10}}, \code{\link{calc_E}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
