/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.nvalue.amnv.mis;

import java.util.BitSet;
import org.chocosolver.solver.constraints.nary.nvalue.amnv.mis.F;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class MD
implements F {
    protected UndirectedGraph graph;
    protected int n;
    protected BitSet out;
    protected BitSet inMIS;
    protected int[] nbNeighbours;
    protected int[] fifo;

    public MD(UndirectedGraph graph) {
        this.graph = graph;
        this.n = graph.getNbMaxNodes();
        this.out = new BitSet(this.n);
        this.inMIS = new BitSet(this.n);
        this.nbNeighbours = new int[this.n];
        this.fifo = new int[this.n];
    }

    @Override
    public void prepare() {
    }

    @Override
    public void computeMIS() {
        this.out.clear();
        this.inMIS.clear();
        for (int i = 0; i < this.n; ++i) {
            this.nbNeighbours[i] = this.graph.getNeighborsOf(i).size();
        }
        int idx = this.out.nextClearBit(0);
        while (idx < this.n) {
            int i = this.out.nextClearBit(idx + 1);
            while (i < this.n) {
                if (this.nbNeighbours[i] < this.nbNeighbours[idx]) {
                    idx = i;
                }
                i = this.out.nextClearBit(i + 1);
            }
            this.addToMIS(idx);
            idx = this.out.nextClearBit(0);
        }
    }

    protected void addToMIS(int node) {
        this.inMIS.set(node);
        this.out.set(node);
        int sizeFifo = 0;
        ISetIterator nei = this.graph.getNeighborsOf(node).iterator();
        while (nei.hasNext()) {
            int j = nei.nextInt();
            if (this.out.get(j)) continue;
            this.out.set(j);
            this.fifo[sizeFifo++] = j;
        }
        for (int i = 0; i < sizeFifo; ++i) {
            nei = this.graph.getNeighborsOf(this.fifo[i]).iterator();
            while (nei.hasNext()) {
                int n = nei.nextInt();
                this.nbNeighbours[n] = this.nbNeighbours[n] - 1;
            }
        }
    }

    @Override
    public BitSet getMIS() {
        return this.inMIS;
    }

    @Override
    public boolean hasNextMIS() {
        return false;
    }
}

