% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{set_bin_prior}
\alias{set_bin_prior}
\title{Construction of a prior distribution for a binomial probability \eqn{p}}
\usage{
set_bin_prior(
  prior = c("jeffreys", "laplace", "haldane", "beta", "mdi", "northrop"),
  ...
)
}
\arguments{
\item{prior}{Either
\itemize{
  \item {An R function that returns the value of the log of the prior
  density (see \strong{Examples}), or}
  \item {A character string giving the name of the prior for \eqn{p}.
    See \strong{Details} for a list of priors available.}
}}

\item{...}{Further arguments to be passed to the user-supplied or in-built
prior function.  For the latter this is only relevant if
\code{prior = "beta"}, when \code{ab} can be passed. See \strong{Details}.}
}
\value{
A list of class \code{"binprior"}.  The first component is the
  name of the input prior.  Apart from the MDI prior this will be "beta",
  in which case the other component of the list is a vector of length two
  giving the corresponding values of the beta parameters.
}
\description{
Constructs a prior distribution for use as the argument \code{bin_prior} in
\code{\link{rpost}} or in \code{\link{binpost}}.  The user can choose
from a list of in-built priors or specify their own prior function,
returning the \strong{log} of the prior density, using an R function
and arguments for hyperparameters.
}
\details{
\strong{Binomial priors.} The names of the binomial priors set using
  \code{bin_prior} are:
\itemize{
  \item{\code{"jeffreys"}: the \emph{Jeffreys} beta(1/2, 1/2) prior.}
  \item{\code{"laplace"}: the \emph{Bayes-Laplace} beta(1, 1) prior.}
  \item{\code{"haldane"}: the \emph{Haldane} beta(0, 0) prior.}
  \item{\code{"beta"}: a beta(\eqn{\alpha, \beta}) prior.  The argument
    \code{ab} is a vector containing \code{c}(\eqn{\alpha, \beta}).
    The default is \code{ab = c(1, 1)}.}
  \item{\code{"mdi"}: the MDI prior
    \eqn{\pi(p) = 1.6186 p^p (1-p)^{1-p}}{\pi(p) = 1.6186 p^p (1-p)^(1-p)},
        for \eqn{0 < p < 1.}}
  \item{\code{"northrop"}: the improper prior
    \eqn{\pi(p)=\{-\ln(1-p)\}^{-1}(1-p)^{-1}}{\pi(p)=1 / [ -ln(1-p) (1-p) ]},
        for \eqn{0 < p < 1.}}
}
Apart from the last two priors these are all beta distributions.
}
\examples{
bp <- set_bin_prior(prior = "jeffreys")

# Setting the Jeffreys prior by hand
beta_prior_fn <- function(p, ab) {
  return(stats::dbeta(p, shape1 = ab[1], shape2 = ab[2], log = TRUE))
}
jeffreys <- set_bin_prior(beta_prior_fn, ab = c(1 / 2, 1 / 2))
}
\seealso{
\code{\link{binpost}} for sampling from a binomial posterior
  distribution.
}
