% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rextendr_document.R
\name{document}
\alias{document}
\title{Compile Rust code and generate package documentation.}
\usage{
document(pkg = ".", quiet = getOption("usethis.quiet", FALSE), roclets = NULL)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[devtools:as.package]{as.package()}} for more information.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{roclets}{Character vector of roclet names to use with package.
The default, \code{NULL}, uses the roxygen \code{roclets} option,
which defaults to \code{c("collate", "namespace", "rd")}.}
}
\value{
No return value, called for side effects.
}
\description{
The function \code{rextendr::document()} updates the package documentation for an
R package that uses \code{extendr} code, taking into account any changes that were
made in the Rust code. It is a wrapper for \code{\link[devtools:document]{devtools::document()}}, and it
executes \code{extendr}-specific routines before calling \code{\link[devtools:document]{devtools::document()}}.
Specifically, it ensures that Rust code is recompiled (when necessary) and that
up-to-date R wrappers are generated before re-generating the package documentation.
}
