% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rf.partial.ci.R
\name{rf.partial.ci}
\alias{rf.partial.ci}
\title{Random Forests regression partial dependency plot with confidence intervals}
\usage{
rf.partial.ci(m, x, yname, xname, lci = 0.25, uci = 0.75, delta = FALSE)
}
\arguments{
\item{m}{randomForest regression object}

\item{x}{data.frame or matrix of independent variables used to build model}

\item{yname}{Name of the dependent variable}

\item{xname}{Name of the independent variable for calculating partial dependence}

\item{lci}{Percentile of predictions to plot as the lower bound.}

\item{uci}{Percentile of predictions to plot as the upper bound.}

\item{delta}{Plot change in prediction between the independent variable and simulated values (Default = NULL)}
}
\value{
recordedplot object to recall plot
}
\description{
Plots the partial dependency, and associated confidence intervals, of a random forests regression model
}
\note{
depends: randomForest
}
\examples{
library(randomForest)
 data(airquality)
 airquality <- na.omit(airquality)
 rf.ozone <- randomForest(y=airquality[,"Ozone"], airquality[,2:ncol(airquality)])

 par(mfrow=c(2,2))
   for(i in c("Solar.R", "Wind", "Temp", "Day")){
     rf.partial.ci(m=rf.ozone, x=airquality, yname="Ozone", xname=i, delta=TRUE)
   }
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

