% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{accuracy}
\alias{accuracy}
\title{Accuracy}
\usage{
accuracy(x, y)
}
\arguments{
\item{x}{vector of predicted data or table/matrix contingency table}

\item{y}{vector of observed data, if x is not table/matrix contingency table}
}
\value{
A list class object with the following components:
\itemize{ 
\item   PCC                    percent correctly classified (accuracy)
\item   auc                    Area Under the ROC Curve
\item   users.accuracy         The users accuracy  
\item   producers.accuracy     The producers accuracy
\item   kappa                  Cohen's Kappa (chance corrected accuracy)
\item   true.skill             Hanssen-Kuiper skill score (aka true score statistic)
\item   sensitivity            Sensitivity (aka, recall)
\item   specificity            Specificity 
\item   plr                    Positive Likelihood Ratio   
\item   nlr                    Negative Likelihood Ratio  
\item   typeI.error            Type I error (omission)
\item   typeII.error           Type II error (comission)
\item   f.score                F-score
\item   gain                   Information gain (aka precision)
\item   mcc                    Matthew's correlation 
\item   confusion              A confusion matrix 
 }
}
\description{
Classification accuracy measures for pcc, kappa, users accuracy, producers accuracy
}
\note{
\itemize{ 
  \item   sensitivity = true positives / ( true positives + false positives ) 
  \item   specificity = true negatives / ( true negatives + false positives ) 
  \item   Type I error = 1 - specificity
  \item   Type II error = 1 - sensitivity
  \item   Positive Likelihood Ratio  = sensitivity / (1 - specificity) 
  \item   Negative Likelihood Ratio  = (1 - sensitivity) / specificity
  \item   gain  = sensitivity / ( (true positives + true negatives) / n )
  \item   auc = (tpr - fpr + 1) / 2
  \item   F-Score = 2 * (precision * recall) / (precision + recall) 
  \item   Hanssen-Kuiper skill score (aka true score statistic) = [(tp * tn) - (fp * fn)] / [(tp + fn) + (fp + tn)], The true skill score has an expected -1 to +1, with 0 representing no discrimination.   
 }
}
\examples{
 # Two classes (vector)
 observed <- sample(c(rep("Pres",50),rep("Abs",50)), 100, replace=TRUE )
 accuracy(observed[sample(1:length(observed))], observed)

 # Two classes (contingency table)
accuracy(cbind(c(15,11), c(2,123)))

 # Multiple classes
 accuracy(iris[sample(1:150),]$Species, iris$Species)

}
\references{
Cohen, J. (1960) A coefficient of agreement for nominal scales. Educational and Psychological Measurement 20 (1):37-46
Cohen, J. (1968) Weighted kappa: Nominal scale agreement with provision for scaled disagreement or partial credit. Psychological Bulletin 70 (4):213-220  
Powers, D.M.W., (2011). Evaluation: From Precision, Recall and F-Measure to ROC, Informedness, Markedness & Correlation. Journal of Machine Learning Technologies 2(1):37-63.
}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
