% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_species.R
\name{get_species}
\alias{get_species}
\title{Get unique species in a given genus in dataframe.}
\usage{
get_species(df, genus)
}
\arguments{
\item{df}{A dataframe in FishNet2 standard format (by using read.csv())}

\item{genus}{Genus of species}
}
\value{
Vector of unique species values or character(0) if empty
}
\description{
\code{get_species} returns all species name that correspond to genus name
input in a FishNet2 dataframe.
}
\details{
This is a function to get the species name of a given genus name. Names are
found using the 'ScientificName' column in a FishNet2 dataframe. If "value is
only one word, no species name is returned.
}
\examples{
get_species(ictaluridae, "Ameirus")
get_species(ictaluridae, "Noturus")
get_species(louisiana, "Scaphirhynchus")
}
