% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_create_class_targets.R
\name{flsgen_create_class_targets}
\alias{flsgen_create_class_targets}
\title{Creates a set of targets for a landscape class}
\usage{
flsgen_create_class_targets(
  class_name,
  NP = NULL,
  AREA = NULL,
  AREA_MN = NULL,
  CA = NULL,
  PLAND = NULL,
  PD = NULL,
  SPI = NULL,
  LPI = NULL,
  MESH = NULL,
  SPLI = NULL,
  NPRO = NULL,
  SDEN = NULL,
  COHE = NULL,
  DIVI = NULL
)
}
\arguments{
\item{class_name}{Name of the class}

\item{NP}{number of patches target (must be a vector of length 2)}

\item{AREA}{patch area target (must be a vector of length 2)}

\item{AREA_MN}{mean patch area target (must be a vector of length 2)}

\item{CA}{total class area target (must be a vector of length 2)}

\item{PLAND}{proportion of landscape target (must be a vector of length 2)}

\item{PD}{patch density target (must be a vector of length 2)}

\item{SPI}{smallest patch index target (must be a vector of length 2)}

\item{LPI}{largest patch index target (must be a vector of length 2)}

\item{MESH}{effective mesh size target (must be a vector of length 2)}

\item{SPLI}{splitting index target (must be a vector of length 2)}

\item{NPRO}{net product target (must be a vector of length 2)}

\item{SDEN}{splitting density target (must be a vector of length 2)}

\item{COHE}{degree of coherence target (must be a vector of length 2)}

\item{DIVI}{degree of landscape division target (must be a vector of length 2)}
}
\value{
A class targets object which can be converted to JSON for flsgen
}
\description{
Creates a set of targets for a landscape class, which can be
converted into JSON for flsgen.
}
\details{
Note that NP and AREA targets can be set as NULL, if the class
targets is used within the `generate_series` function to generate landscape
series with varying NP and/or AREA. However, flsgen won't run is NP and
AREA are not set elsewhere.
}
\examples{
  \dontrun{
    cls_1 <- flsgen_create_class_targets("class 1", NP=c(1, 10), AREA=c(0, 1000))
  }
}
