% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_generate.R
\name{flsgen_generate}
\alias{flsgen_generate}
\title{Landscape raster generator}
\usage{
flsgen_generate(
  structure_str,
  structure_file,
  output = tempfile(fileext = ".tif"),
  terrain_file = NULL,
  roughness = 0.5,
  terrain_dependency = 0.5,
  min_distance = 2,
  min_max_distance = NULL,
  connectivity = 4,
  x = 0,
  y = 0,
  resolution_x = 1e-04,
  resolution_y = NULL,
  epsg = "EPSG:4326",
  max_try = 2,
  max_try_patch = 10,
  verbose = TRUE
)
}
\arguments{
\item{structure_str}{JSON-formatted string describing the landscape structure to generate}

\item{structure_file}{JSON file containing the landscape structure to generate}

\item{output}{Path of output raster file (temporary file by default)}

\item{terrain_file}{Path of input terrain raster file, if NULL a terrain is generated with the diamond-square algorithm}

\item{roughness}{Roughness factor (or H), between 0 and 1 (only need when terrain_file is NULL)}

\item{terrain_dependency}{Terrain dependency factor for landscape generation, between 0 and 1}

\item{min_distance}{Minimum distance between patches of a same class}

\item{min_max_distance}{If defined, the minimum distance beween patches of a
same class is defined by a variable buffer of width between
min_distance and min_max_distance}

\item{connectivity}{Connectivity definition in the regular square grid (4 or 8)."}

\item{x}{X position (geographical coordinates) of the top-left output raster pixel}

\item{y}{Y position (geographical coordinates) of the top-left output raster pixel}

\item{resolution_x}{x spatial resolution (geographical units) of the output raster (i.e. pixel width)}

\item{resolution_y}{y-spatial resolution (geographical units) of the output raster (i.e. pixel height),
if null, resolution_x is used}

\item{epsg}{EPSG identifier of the output projection}

\item{max_try}{Maximum number of trials for landscape generation}

\item{max_try_patch}{Maximum number of trials for patch generation}

\item{verbose}{if TRUE print information about generation}
}
\value{
A raster object
}
\description{
Generate landscape raster from landscape structure
}
\details{
The input landscape structure must be either specified as a JSON-formatted string
 (structure_str parameter) or as a JSON file (structure_file parameter)
}
\examples{
  \dontrun{
    json <- "{
      \"nbRows\" : 200,
      \"nbCols\" : 200,
      \"classes\" : [
        {
          \"name\" : \"Class A\",
          \"NP\" : [1, 10],
          \"AREA\" : [300, 4000],
          \"CA\" : [1000, 5000],
          \"MESH\" : [225, 225]
        },
        {
          \"name\" : \"Class B\",
          \"NP\" : [2, 8],
          \"AREA\" : [200, 4000],
          \"PLAND\" : [40, 40]
        },
        {
          \"name\" : \"Class C\",
           \"NP\" : [5, 7],
           \"AREA\" : [800, 1200]
        }
      ]
    }"
    structure <- flsgen_structure(targets_str = json)
    landscape <- flsgen_generate(structure_str = structure)
  }

}
