/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUnionOperations {
    public static final Comparator<CharSequence> LEXICOGRAPHIC_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            int n = charSequence.length();
            int n2 = charSequence2.length();
            int n3 = Math.min(n, n2);
            for (int i = 0; i < n3; ++i) {
                char c;
                char c2 = charSequence.charAt(i);
                if (c2 == (c = charSequence2.charAt(i))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    };
    private HashMap<State, State> register = new HashMap();
    private State root = new State();
    private StringBuilder previous;

    public void add(CharSequence charSequence) {
        State state;
        int n;
        assert (this.register != null) : "Automaton already built.";
        assert (charSequence.length() > 0) : "Input sequences must not be empty.";
        assert (this.previous == null || LEXICOGRAPHIC_ORDER.compare(this.previous, charSequence) <= 0) : "Input must be sorted: " + this.previous + " >= " + charSequence;
        assert (this.setPrevious(charSequence));
        int n2 = charSequence.length();
        State state2 = this.root;
        for (n = 0; n < n2 && (state = state2.lastChild(charSequence.charAt(n))) != null; ++n) {
            state2 = state;
        }
        if (state2.hasChildren()) {
            this.replaceOrRegister(state2);
        }
        this.addSuffix(state2, charSequence, n);
    }

    public State complete() {
        if (this.register == null) {
            throw new IllegalStateException();
        }
        if (this.root.hasChildren()) {
            this.replaceOrRegister(this.root);
        }
        this.register = null;
        return this.root;
    }

    private static dk.brics.automaton.State convert(State state, IdentityHashMap<State, dk.brics.automaton.State> identityHashMap) {
        dk.brics.automaton.State state2 = identityHashMap.get(state);
        if (state2 != null) {
            return state2;
        }
        state2 = new dk.brics.automaton.State();
        state2.setAccept(state.is_final);
        identityHashMap.put(state, state2);
        int n = 0;
        char[] cArray = state.labels;
        for (State state3 : state.states) {
            state2.addTransition(new Transition(cArray[n++], StringUnionOperations.convert(state3, identityHashMap)));
        }
        return state2;
    }

    public static dk.brics.automaton.State build(CharSequence[] charSequenceArray) {
        StringUnionOperations stringUnionOperations = new StringUnionOperations();
        for (CharSequence charSequence : charSequenceArray) {
            stringUnionOperations.add(charSequence);
        }
        return StringUnionOperations.convert(stringUnionOperations.complete(), new IdentityHashMap<State, dk.brics.automaton.State>());
    }

    private boolean setPrevious(CharSequence charSequence) {
        if (this.previous == null) {
            this.previous = new StringBuilder();
        }
        this.previous.setLength(0);
        this.previous.append(charSequence);
        return true;
    }

    private void replaceOrRegister(State state) {
        State state2;
        State state3 = state.lastChild();
        if (state3.hasChildren()) {
            this.replaceOrRegister(state3);
        }
        if ((state2 = this.register.get(state3)) != null) {
            state.replaceLastChild(state2);
        } else {
            this.register.put(state3, state3);
        }
    }

    private void addSuffix(State state, CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        for (int i = n; i < n2; ++i) {
            state = state.newState(charSequence.charAt(i));
        }
        state.is_final = true;
    }

    static final class State {
        private static final char[] NO_LABELS = new char[0];
        private static final State[] NO_STATES = new State[0];
        char[] labels = NO_LABELS;
        State[] states = NO_STATES;
        boolean is_final;

        State() {
        }

        public State getState(char c) {
            int n = Arrays.binarySearch(this.labels, c);
            return n >= 0 ? this.states[n] : null;
        }

        public char[] getTransitionLabels() {
            return this.labels;
        }

        public State[] getStates() {
            return this.states;
        }

        public boolean equals(Object object) {
            State state = (State)object;
            return this.is_final == state.is_final && Arrays.equals(this.labels, state.labels) && State.referenceEquals(this.states, state.states);
        }

        public boolean hasChildren() {
            return this.labels.length > 0;
        }

        public boolean isFinal() {
            return this.is_final;
        }

        public int hashCode() {
            int n = this.is_final ? 1 : 0;
            n ^= n * 31 + this.labels.length;
            for (char c : this.labels) {
                n ^= n * 31 + c;
            }
            for (State state : this.states) {
                n ^= System.identityHashCode(state);
            }
            return n;
        }

        State newState(char c) {
            assert (Arrays.binarySearch(this.labels, c) < 0) : "State already has transition labeled: " + c;
            this.labels = State.copyOf(this.labels, this.labels.length + 1);
            this.states = State.copyOf(this.states, this.states.length + 1);
            this.labels[this.labels.length - 1] = c;
            State state = new State();
            this.states[this.states.length - 1] = state;
            return state;
        }

        State lastChild() {
            assert (this.hasChildren()) : "No outgoing transitions.";
            return this.states[this.states.length - 1];
        }

        State lastChild(char c) {
            int n = this.labels.length - 1;
            State state = null;
            if (n >= 0 && this.labels[n] == c) {
                state = this.states[n];
            }
            assert (state == this.getState(c));
            return state;
        }

        void replaceLastChild(State state) {
            assert (this.hasChildren()) : "No outgoing transitions.";
            this.states[this.states.length - 1] = state;
        }

        private static char[] copyOf(char[] cArray, int n) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n));
            return cArray2;
        }

        public static State[] copyOf(State[] stateArray, int n) {
            State[] stateArray2 = new State[n];
            System.arraycopy(stateArray, 0, stateArray2, 0, Math.min(stateArray.length, n));
            return stateArray2;
        }

        private static boolean referenceEquals(Object[] objectArray, Object[] objectArray2) {
            if (objectArray.length != objectArray2.length) {
                return false;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == objectArray2[i]) continue;
                return false;
            }
            return true;
        }
    }
}

