% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{gd_authenticate}
\alias{gd_authenticate}
\title{Authenticate with Google Earth Engine using \code{gcloud}, "Notebook Authenticator" or other method}
\usage{
gd_authenticate(
  authorization_code = NULL,
  quiet = FALSE,
  code_verifier = NULL,
  auth_mode = NULL
)
}
\arguments{
\item{authorization_code}{Default: \code{NULL}}

\item{quiet}{Suppress warnings, errors, messages? Default: \code{FALSE}}

\item{code_verifier}{Optional code verifier for security Default: \code{NULL}}

\item{auth_mode}{One of \code{"notebook"}, \code{"gcloud"}, \code{"appdefault"} or (default) \code{NULL} to guess based on the environment}
}
\value{
This function is primarily used for the side-effect of authentication with the 'Google Earth Engine' servers. Invisibly returns \code{try-error} on error.
}
\description{
Calls \code{ee.Authenticate(...)} to authenticate with Earth Engine.
}
\details{
This method should be called once to set up a machine/project with a particular authentication method. The \code{auth_mode="notebook"} argument is very convenient for interactive R use and will take you to a web page where you can sign into your Google Account and get a token to paste into a console prompt.
}
\examples{
\dontrun{
# opens web page to complete authentication/provide authorization code
gd_authenticate(auth_mode = "notebook")
}
}
