% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComByDep.R
\name{ComByDep}
\alias{ComByDep}
\title{Get Cities by Department}
\usage{
ComByDep(codeDepartement, postal = FALSE)
}
\arguments{
\item{codeDepartement}{a numeric vector with a department INSEE Code.}

\item{postal}{wether or not to include postal codes. Default is FALSE.}
}
\value{
Returns a data.frame with names of the cities, INSEE codes, postal codes, INSEE department codes, INSEE region codes, population of the cities (approx), surface of the cities (in hectares), lat and long of the cities (WGS-84).
}
\description{
Get informations about all the cities in a French department by its INSEE Code. Please note that this package works only with French cities.
}
\details{
Takes a department INSEE Code, returns a data.frame with the available values.
}
\note{
If you don't know the INSEE code of the department you're looking for, you can find it by using the \code{\link{DepByName}} function.
}
\examples{
ComByDep(codeDepartement = 35) 
ComByDep(codeDepartement = 29, postal = TRUE)
}

