% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{natural_breaks}
\alias{natural_breaks}
\title{Natural Breaks (Jenks)}
\usage{
natural_breaks(k, data)
}
\arguments{
\item{k}{A numeric value indicates how many breaks}

\item{data}{A vector of numeric values}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Natural Breaks group data whose boundaries are set where there are relatively big differences.
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
natural_breaks(k=5, data=crm_prs)
}
