% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gads_get_metadata.R
\name{gads_get_metadata}
\alias{gads_get_metadata}
\title{Get metada of object, RESOURCE, ATTRIBUTE, METRIC or SEGMENT}
\usage{
gads_get_metadata(
  category = c("RESOURCE", "ATTRIBUTE", "METRIC", "SEGMENT", "ALL"),
  fields = c("name", "category", "data_type", "selectable", "filterable", "sortable",
    "selectable_with", "metrics", "segments", "is_repeated", "type_url", "enum_values",
    "attribute_resources")
)
}
\arguments{
\item{category}{Object category}

\item{fields}{Metadata fields}
}
\value{
tibble with object metadata
important arrays in result:
\describe{
\item{attributeResources}{Resources that can be using in \code{resource} argument in \code{\link{gads_get_report}}.}
\item{metrics}{Metrics that are available to be selected with the resource in the \code{field} argument in \code{\link{gads_get_report}}. Only populated for fields where the category is RESOURCE.}
\item{segments}{Segment keys that can be selected with the resource in the \code{field} argument in \code{\link{gads_get_report}}. These segment the metrics specified in the query. Only populated for fields where the category is RESOURCE.}
\item{selectableWith}{Fields that can be selected alongside a given field, when not in the FROM clause. This attribute is only relevant when identifying resources or segments that are able to be selected in a query where they are not included by the resource in the FROM clause. As an example, if we are selecting \code{ad_group.id} and \code{segments.date} from \code{ad_group}, and we want to include attributes from \code{campaign}, we would need to check that \code{segments.date} is in the selectableWith attribute for campaign, since it's being selected alongside the existing \code{segments.date} field.}
}
}
\description{
Get metada of object, RESOURCE, ATTRIBUTE, METRIC or SEGMENT
}
\examples{
\dontrun{
# get resource list
resources <- gads_get_metadata("RESOURCE")

# get list of all objects
metadata <- gads_get_metadata("ALL")

}
}
\seealso{
\href{https://ads-developers.googleblog.com/2021/04/the-query-builder-blog-series-part-3.html}{The Query Builder Blog Series: Part 3 - Creating a Resource Schema}
and \href{https://developers.google.com/google-ads/api/docs/concepts/field-service}{Resource Metadata API documentation}
}
