% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEM_request.R
\name{DEM_request}
\alias{DEM_request}
\title{returns a data frame with metadata and links to the Digital Elevation Models
in a given polygon}
\usage{
DEM_request(polygon)
}
\arguments{
\item{polygon}{the polygon layer (may consist of n objects)}
}
\value{
a data frame with metadata and links to the Digital Elevation Models
(different formats of Digital Terrain Model, Digital Surface Model and
point clouds)
}
\description{
returns a data frame with metadata and links to the Digital Elevation Models
in a given polygon
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)
req_df = DEM_request(polygon)

# simple filtering by attributes
req_df = req_df[req_df$year > 2018, ]
req_df = req_df[req_df$product == "PointCloud" & req_df$format == "LAS", ]
}
}
