% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierBAPS.R
\name{hierBAPS}
\alias{hierBAPS}
\title{hierBAPS}
\usage{
hierBAPS(snp.matrix, max.depth = 2, n.pops = floor(nrow(snp.matrix)/5),
  quiet = FALSE, n.extra.rounds = 0, assignment.probs = FALSE,
  n.cores = 1)
}
\arguments{
\item{snp.matrix}{Character matrix of aligned sequences produced by \link{load_fasta}.}

\item{max.depth}{Maximum depth of hierarchical search (default = 2).}

\item{n.pops}{Maximum number of populations in the data (default = number of isolates/5)}

\item{quiet}{Whether to suppress progress information (default=FALSE).}

\item{n.extra.rounds}{The number of additional rounds to perform after the default hierBAPS
settings (default=0). If set to Inf it will run until a local optimum is reached
(this might take a long time).}

\item{assignment.probs}{whether or not to calculate the assignment probabilities to each cluster (default=FALSE)}

\item{n.cores}{The number of cores to use.}
}
\value{
A list containing a dataframe indicating an assignment of each sequence
to hierarchical clusters as well as the log marginal likelihoods for each level.
}
\description{
Runs the hierBAPS algorithm of Cheng et al. 2013
}
\examples{
snp.matrix <- load_fasta(system.file("extdata", "small_seqs.fa", package = "rhierbaps"))
hb <- hierBAPS(snp.matrix, max.depth=2, n.pops=20, quiet=FALSE)

\donttest{
snp.matrix <- load_fasta(system.file("extdata", "seqs.fa", package = "rhierbaps"))
system.time({hb <- hierBAPS(snp.matrix, max.depth=2, n.pops=20, quiet=FALSE)})
}

}
\references{
Cheng, Lu, Thomas R. Connor, Jukka Sirén, David M. Aanensen, and Jukka Corander. 2013. “Hierarchical and Spatially Explicit Clustering of DNA Sequences with BAPS Software.” Molecular Biology and Evolution 30 (5): 1224–28.
}
\author{
Gerry Tonkin-Hill
}
