% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{app}
\alias{app}
\title{Rhino application}
\usage{
app()
}
\value{
An object representing the app (can be passed to \code{shiny::runApp()}).
}
\description{
The entrypoint for a Rhino application.
Your \code{app.R} should contain nothing but a call to \code{rhino::app()}.
}
\details{
This function is a wrapper around \code{shiny::shinyApp()}.
It reads \code{rhino.yml} and performs some configuration steps (logger, static files, box modules).
You can run a Rhino application in typical fashion using \code{shiny::runApp()}.

Rhino will load the \code{app/main.R} file as a box module (\code{box::use(app/main)}).
It should export two functions which take a single \code{id} argument -
the \code{ui} and \code{server} of your top-level Shiny module.
}
\section{Legacy entrypoint}{
It is possible to specify a different way to load your application
using the \code{legacy_entrypoint} option in \code{rhino.yml}:
\enumerate{
\item \code{app_dir}: Rhino will run the app using \code{shiny::shinyAppDir("app")}.
\item \code{source}: Rhino will \code{source("app/main.R")}.
This file should define the top-level \code{ui} and \code{server} objects to be passed to \code{shinyApp()}.
\item \code{box_top_level}: Rhino will load \code{app/main.R} as a box module (as it does by default),
but the exported \code{ui} and \code{server} objects will be considered as top-level.
}

The \code{legacy_entrypoint} setting is useful when migrating an existing Shiny application to Rhino.
It is recommended to transform your application step by step:
\enumerate{
\item With \code{app_dir} you should be able to run your application right away
(just put the files in the \code{app} directory).
\item With \code{source} setting your application structure must be brought closer to Rhino,
but you can still use \code{library()} and \code{source()} functions.
\item With \code{box_top_level} you can be confident that the whole app is properly modularized,
as box modules can only load other box modules (\code{library()} and \code{source()} won't work).
\item The last step is to remove the \code{legacy_entrypoint} setting completely.
Compared to \code{box_top_level} you'll need to make your top-level \code{ui} and \code{server}
into a \href{https://shiny.rstudio.com/articles/modules.html}{Shiny module}
(functions taking a single \code{id} argument).
}
}

\examples{
\dontrun{
  # Your `app.R` should contain nothing but this single call:
  rhino::app()
}
}
