% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bispectra.R
\name{bicoherence}
\alias{bicoherence}
\title{Estimate bicoherence from given time series data.}
\usage{
bicoherence(data, window_function = NULL, alpha = 0.05, p_adjust_method = "BH")
}
\arguments{
\item{data}{Given time series, as a data frame or matrix with which columns
correspond to sampled stretches.}

\item{window_function}{A window function's name for tapering. Defaults to
\code{NULL} ("no tapering").

Currently the following window functions are available: Hamming window ("hamming"),
Hann window ("hann"), and Blackman window ("blackman").}

\item{alpha}{The alpha level of the hypotesis test. Defaults to 0.05.}

\item{p_adjust_method}{The correction method for p-values, given to
\code{\link[stats]{p.adjust}()}. Defaults to "BH" (Benjamini and Hochberg).
No correction if a non-character is given.}
}
\value{
A data frame including the following columns:
\describe{
\item{f1:}{
The first elements of frequency pairs.
}
\item{f2:}{
The second elements of frequency pairs.
}
\item{value:}{
The estimate of magnitude-squared bicoherence at the respective frequency
pair.
}
\item{p_value:}{
The (corrected, if requested) p-value for hypothesis testing under null
hypothesis that bicoherence is 0.
}
\item{significance:}{
TRUE if the null hypothesis of the above hypothesis test is rejected
with given \code{alpha} level.
}
}
}
\description{
Estimate magnitude-squared bicoherence from given real- or complex-valued
time series data.
}
\examples{
f <- function(x) {
    sin(2 * x) + sin(3 * x + 1) + sin(2 * x) * sin(3 * x + 1)
}
v <- sapply(seq_len(1280), f) + rnorm(1280)
m <- matrix(v, nrow = 128)
bicoherence(m)
bicoherence(m, "hamming")

}
\references{
Brillinger, D.R. and Irizarry, R.A.
"An investigation of the second- and higher-order spectra of music."
Signal Processing, Volume 65, Issue 2, 30 March 1998, Pages 161-179.
}
