% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{F14CtoD14C}
\alias{F14CtoD14C}
\title{Transform F14C into D14C}
\usage{
F14CtoD14C(F14C, er = NULL, t, roundby = NA)
}
\arguments{
\item{F14C}{The F14C value to translate}

\item{er}{Reported error of the F14C. Returns just the mean if left empty.}

\item{t}{the cal BP age}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}
}
\value{
The corresponding D14C value
}
\description{
Transform F14C into D14C
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates F14C values into Delta14C, the historical level of Delta14C in the year t cal BP. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
  F14CtoD14C(0.89, .001, 900)
}
