% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.ccurve}
\alias{draw.ccurve}
\title{Draw a calibration curve.}
\usage{
draw.ccurve(
  cal1 = c(),
  cal2 = c(),
  cc1 = "IntCal20",
  cc2 = NA,
  cc1.postbomb = FALSE,
  cc2.postbomb = FALSE,
  BCAD = FALSE,
  timescale = "C14",
  as.F = FALSE,
  as.pMC = FALSE,
  as.Delta = FALSE,
  timescale2 = c(),
  cal.lab = c(),
  cal.rev = FALSE,
  c14.lab = c(),
  cc2.lab = c(),
  c14.lim = c(),
  c14.rev = FALSE,
  ka = FALSE,
  add.yaxis = FALSE,
  cc1.col = rgb(0, 0, 1, 0.5),
  cc1.fill = rgb(0, 0, 1, 0.2),
  cc2.col = rgb(0, 0.5, 0, 0.5),
  cc2.fill = rgb(0, 0.5, 0, 0.2),
  add = FALSE,
  bty = "l",
  mar = c(),
  mgp = c(),
  cc.dir = NULL,
  legend = "topleft",
  ...
)
}
\arguments{
\item{cal1}{First calendar year for the plot. Defaults to 0 cal BP.}

\item{cal2}{Last calendar year for the plot. Defaults to 55,000 cal BP.}

\item{cc1}{Name of the calibration curve. Can be "IntCal20", "Marine20", "SHCal20", or for the previous curves "IntCal13", "Marine13" or "SHCal13". Can also be "nh1", "nh2", "nh3", "sh1-2", "sh3", "nh1_monthly", "nh1_monthly", "nh2_monthly", "nh3_monthly", "sh1-2_monthly", "sh3_monthly", "Kure", "LevinKromer" or "Santos" for postbomb curves.}

\item{cc2}{Optional second calibration curve to plot. Can be "IntCal20", "Marine20", "SHCal20", or for the previous curves "IntCal13", "Marine13" or "SHCal13". Defaults to nothing, NA.}

\item{cc1.postbomb}{Use \code{postbomb=TRUE} to get a postbomb calibration curve for cc1 (default \code{cc1.postbomb=FALSE}).}

\item{cc2.postbomb}{Use \code{postbomb=TRUE} to get a postbomb calibration curve for cc2 (default \code{cc2.postbomb=FALSE}).}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to cal BC/AD using \code{BCAD=TRUE}.}

\item{timescale}{Which timescale of radiocarbon to use. Defaults to \code{timescale="C14"} but can also be set to \code{timescale="F14C"}, \code{timescale="pMC"} or \code{timescale="Delta14C"}. Can be shorted to, respectively, "C", "F", "P" or "D" (or their lower-case equivalents). Alternatively, the timescale can be defined using `as.F=TRUE`, `as.pMC=TRUE` or `as.Delta=TRUE`.}

\item{as.F}{Plot as F14C values. Defaults to \code{as.F=FALSE}.}

\item{as.pMC}{Plot as pMC values. Defaults to \code{as.pMC=FALSE}.}

\item{as.Delta}{Plot as Delta14C values. Defaults to \code{as.Delta=FALSE}.}

\item{timescale2}{Which timescale to use for the second calibration curve (if used). Defaults to \code{timescale2="C14"} but can also be set to \code{timescale2="F14C"}, \code{timescale2="pMC"} or \code{timescale2="Delta14C"}. Can be shorted to, respectively, "C", "F", "P" or "D" (or their lower-case equivalents).}

\item{cal.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}), or to \code{age.lab="kcal BP"} etc. if ka=TRUE.}

\item{cal.rev}{Reverse the calendar axis.}

\item{c14.lab}{Label for the C-14 axis. Defaults to 14C BP (or 14C kBP if ka=TRUE).}

\item{cc2.lab}{Label for the righthand axis (if present). Defaults to the chosen timescale.}

\item{c14.lim}{Axis limits for the C-14 axis. Calculated automatically by default.}

\item{c14.rev}{Reverse the C-14 axis.}

\item{ka}{Use kcal BP (and C14 kBP).}

\item{add.yaxis}{Whether or not to plot the second calibration. Defaults to \code{add.yaxis=FALSE}.}

\item{cc1.col}{Colour of the calibration curve (outline).}

\item{cc1.fill}{Colour of the calibration curve (fill).}

\item{cc2.col}{Colour of the calibration curve (outline), if activated (default cc2=NA).}

\item{cc2.fill}{Colour of the calibration curve (fill), if activated (default cc2=NA).}

\item{add}{Whether or not to add the curve(s) to an existing plot. Defaults to FALSE, which draws a new plot.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}

\item{mar}{Plot margins (amount of white space along edges of axes 1-4). Defaults to give more white space if a second y-axis is to be plotted.}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{legend}{Location of the legend (only activated if more than one curve is plotted). Plotted in the topleft corner by default. Use \code{legend=c()} to leave empty}

\item{...}{Any additional optional plotting parameters.}
}
\value{
A plot of the calibration curve
}
\description{
Draw one or two of the calibration curves, or add a calibration curve to an existing plot.
}
\examples{
draw.ccurve()
draw.ccurve(1000, 3000, cc2="Marine20")
draw.ccurve(1800, 2020, BCAD=TRUE, cc2="nh1", cc2.postbomb=TRUE)
draw.ccurve(1800, 2010, BCAD=TRUE, cc2="nh1", add.yaxis=TRUE)
}
