\name{linearRidge}
\alias{linearRidge}
\alias{coef.ridgeLinear}
\alias{nobs.ridgeLinear}
\alias{plot.ridgeLinear}
\alias{predict.ridgeLinear}
\alias{print.ridgeLinear}
\alias{summary.ridgeLinear}
\alias{print.summary.ridgeLinear}
\title{
Linear ridge regression.
}
\description{
Fits a linear ridge regression model. Optionally, the ridge regression parameter is chosen automatically using 
the method proposed by Cule et al (2012).
}
\usage{
linearRidge(formula, data, lambda = "automatic", nPCs = NULL,
scaling = c("corrForm", "scale", "none"), ...)

\method{coef}{ridgeLinear}(object, all.coef = FALSE, ...)

\method{plot}{ridgeLinear}(x, y = NULL, ...)

\method{predict}{ridgeLinear}(object, newdata, na.action = na.pass, all.coef = FALSE, ...)

\method{print}{ridgeLinear}(x, all.coef = FALSE, ...)

\method{summary}{ridgeLinear}(object, all.coef = FALSE, ...)

\method{print}{summary.ridgeLinear}(x, digits = max(3,
getOption("digits") - 3),
signif.stars = getOption("show.signif.stars"), ...) 

}
\arguments{
  \item{formula}{
    a formula expression as for regression models, of the form \code{response ~ predictors}. See the 
    documentation of \code{formula} for other details.
  }
  \item{data}{
    an optional data frame in which to interpret the variables occuring in \code{formula}.
  }
  \item{lambda}{
    A ridge regression parameter. May be a vector. If \code{lambda} is \code{"automatic"} (the default), then the ridge parameter 
    is chosen automatically using the method of Cule et al (2012).
  }
  \item{nPCs}{
    The number of principal components to use to choose the ridge regression parameter, following the method of 
    Cule et al (2012). It is not possible to specify both \code{lambda} and \code{nPCs}.
  }
  \item{scaling}{
    The method to be used to scale the predictors. One of
    \code{"corrform"}(the default) scales the predictors to correlation form, such that the correlation matrix 
    has unit diagonal.
    \code{"scale"}Standardizes the predictors to have mean zero and unit variance.
    \code{"none"}No scaling.
  }
  \item{object}{
    A ridgeLinear object, typically generated by a call to \code{linearRidge}.
  }
  \item{newdata}{
    An optional data frame in which to look for variables with
    which to predict.  If omitted, the fitted values are used.
  }
  \item{na.action}{
    function determining what should be done with missing values
    in \code{newdata}.  The default is to predict \code{NA}.
  }
  \item{all.coef}{
    Logical. Should results be returned for all ridge regression penalty
    parameters (\code{all.coef = TRUE}), or only for the ridge parameter chosen automatically using the method of Cule et al?
  }
  \item{x}{An object of class \code{ridgeLinear} (for the
    \code{print.ridgeLinear} and \code{plot.ridgeLinear} functions) or an object of class
    \code{summary.ridgeLinear} (for the \code{print.summary.ridgeLinear}
    function)}
  \item{y}{Dummy argument for compatibility with the default \code{plot}
    method. Ignored.}
  \item{digits}{minimum number of significant digits to be used for most numbers}
  \item{signif.stars}{logical; if \code{TRUE}, P-values are additionally encoded
    visually as \code{significance stars} in order to help scanning of
    long coefficient tables.  It defaults to the
    \code{show.signif.stars} slot of \code{options}.
  }
  \item{\dots}{
    Additional arguments to be passed to or from other methods.
  }

}
\details{
	If an intercept is present in the model, its coefficient is not penalised. If you want to penalise an 
	intercept, put in your own constant term and remove the intercept.
}
\value{
	An object of class \code{"ridgeLinear"}, with components:
	\item{automatic}{Logical. Was \code{lambda} chosen automatically?}
	\item{call}{The matched call.}
	\item{coef}{A named vector of fitted coefficients.}
	\item{df}{A vector of degrees of freedom of the model fit, degrees of freedom for variance, and residual 
	degrees of freedom of the fitted model.}
	\item{Inter}{Was an intercept included?}
	\item{isScaled}{Were the predictors scaled before the model was fitted?}
	\item{lambda}{The ridge regression parameter(s).}
	\item{scales}{The scales used to standardize the predictors.}
	\item{terms}{The \code{\link{terms}} object used.}
	\item{x}{The scaled predictor matrix.}
	\item{xm}{A vector of means of the predictors.}
	\item{y}{The response.}
	\item{ym}{The mean of the response.}

	And optionally the components

	\item{max.nPCs}{The maximum number of principal components for which a ridge regression parameter was computed.}
	\item{chosen.nPCs}{The number of principal components used to compute the ridge parameter.}
}
\references{
A semi-automatic method to guide the choice of ridge parameter in ridge regression. Cule, E. and De Iorio, M. (2012) arXiv:1205.0686v1 [stat.AP] 
}
\author{
  Erika Cule
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{logisticRidge}}
}
\examples{
data(GenCont)
mod <- linearRidge(Phenotypes ~ ., data = as.data.frame(GenCont))
summary(mod)
}
