% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R, R/engine.utils.R
\name{maxima.engine}
\alias{maxima.engine}
\alias{maxima.engine.format}
\title{knitr maxima engine}
\usage{
maxima.engine(options)

maxima.engine.format(format = "linear")
}
\arguments{
\item{options}{Named \code{list} of knitr options. Currently there are no maxima specific chunk options. To change the output format of the maxima engine set the variable \code{maxima.engine.format} to either "linear" (default), "latex", "mathml" or "text2d".}

\item{format}{Character vector of length 1 naming the output format to be used for the \code{knitr} engine}
}
\value{
This functions prints the resulting output from maxima together with it's code
}
\description{
An R-function that is registered as a knitr engine when package \code{rim} is attached, i.e. \code{library(rim)}.
}
\details{
\code{maxima.engine} is called by \code{knit()} to evaluate maxima code chunks. When called upon the first code chunk of a document it runs Maxima in the in a separate process in server mode. This means that a single Maxima session is used for all Maxima code chunks of an RMarkdown document. Inputs and outputs can thus be used across chunks (using e.g. Maxima reference labels).  

In addition, this function sets up Maxima specific output and chunk hooks to be used via chunk options.
}
\section{Functions}{
\itemize{
\item \code{maxima.engine.format}: Sets the knitr engine format. It can be used both to set or get the current engine format. The current engine format is returned in both cases.
}}

