% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc_get_points.R
\name{ipc_get_points}
\alias{ipc_get_points}
\title{Get points resources from the IPC API}
\usage{
ipc_get_points(
  year = NULL,
  type = NULL,
  id = NULL,
  period = NULL,
  api_key = NULL,
  tidy_df = TRUE
)
}
\arguments{
\item{year}{Single numeric year to filter analysis, calculated from the
maximum year of current period dates. If \code{NULL}, the default, returns
data for all years.}

\item{type}{Single string value of 'A' or 'C', corresponding to food security
conditions, either acute or chronic. If \code{NULL}, the default, returns
data for all types.}

\item{id}{Analysis ID.}

\item{period}{Period code, either 'C', 'P', or 'A' for current, projection,
and second projection.}

\item{api_key}{IPC API key. If \code{NULL} (the default), looks for \code{IPC_API_KEY}
in the environment.}

\item{tidy_df}{If \code{TRUE}, returns a tidy data frame wrangled as described in
the Tidy section of the documentation. If \code{FALSE}, returns
the data frame as returned direct from the IPC-CH API.}
}
\value{
Data frame of IPC and CH analysis at the point level. Refer to the
\href{https://docs.api.ipcinfo.org}{IPC-CH Public API documentation} for details
on the returned values, with variables described in full in the \href{https://observablehq.com/@ipc/ipc-api-extended-documentation}{extended documentation}.
}
\description{
Accesses the points resources on the IPC API. Contains detailed area and
population data. If \code{year} and/or \code{type} parameters are passed, accesses
the \strong{types} simplified API endpoint and pulls in all types data or filtered to
either \code{year} or \code{type}. To get all types for a specific analysis
and period, available on the \strong{types/\{id\}/\{period\}} advanced API endpoint,
pass in \code{id} and \code{period}. You cannot pass in both sets of parameters.
}
\details{
Points data is IPC data generated from analysis on geographic
entities that are smaller than the standard areas. These are typically
urban areas or displacement sites where food insecurity conditions might
differ significantly from the wider context and justify specific analysis.
Population estimates as well as an overall phase classification are provided
for each point. Data is currently output only for current
periods through the \strong{points} endpoint. Use \code{\link[=ipc_get_population]{ipc_get_population()}} to get
detailed population data and classifications for all analysis periods. Points
data is contained within the \code{areas} dataset returned from
\code{\link[=ipc_get_population]{ipc_get_population()}}.

See the \href{https://www.ipcinfo.org}{IPC website} and
\href{https://docs.api.ipcinfo.org}{API documentation} for more information.
}
\section{Tidy}{

When \code{tidy_df} is \code{TRUE}, the following changes are made to the initial
output to ensure each row represents a single point analysis, and all estimates
and values are stored as columns:
\enumerate{
\item \code{phases} is unnested from a list column to bring the phase data into the
main data frame.
\item The population estimates are pivoted to a wider format with names \code{phase#_num}
and \code{phase#_pct}.
\item \code{aar_id} is renamed to \code{area_id} and \code{anl_id} to \code{analysis_id}.
}
}

\examples{
\dontshow{if (!is.na(Sys.getenv("IPC_API_KEY", unset = NA))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# get all areas from the simplified API
ipc_get_points()

# get areas for specific analysis ID and period from advanced API
ipc_get_points(id = 18978466, period = "P")
\dontshow{\}) # examplesIf}
}
