% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{cran_revdep}
\alias{cran_revdep}
\title{Find Reverse Dependencies of a CRAN Package}
\usage{
cran_revdep(
  pkg,
  dependencies = c("Depends", "Imports", "Suggests", "LinkingTo"),
  recursive = FALSE,
  ignore = NULL,
  installed = NULL
)
}
\arguments{
\item{pkg}{A character string representing the name of the package.}

\item{dependencies}{A character vector specifying the types of dependencies to consider. Default is c("Depends", "Imports", "Suggests", "LinkingTo").}

\item{recursive}{A logical value indicating whether to find dependencies recursively. Default is FALSE.}

\item{ignore}{A character vector of package names to ignore. Default is NULL.}

\item{installed}{A matrix of installed packages.}
}
\value{
deps - A sorted character vector of package names that depend on the specified package.
}
\description{
This function finds the reverse dependencies of a CRAN package, i.e., packages that depend on the specified package.
}
\examples{
\donttest{
cran_revdep("ggplot2")
}

}
