% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pubmed_data.R
\name{get_pubmed_by_year}
\alias{get_pubmed_by_year}
\title{Get Annual PubMed Article Counts for a Search Term}
\usage{
get_pubmed_by_year(
  package_name,
  years_back = 10,
  api_key = getOption("pubmed.api_key", NULL)
)
}
\arguments{
\item{package_name}{A character string representing the search term (e.g., an R package name).}

\item{years_back}{An integer specifying how many years back to query. Defaults to 10.}

\item{api_key}{Optional. A character string with an NCBI API key. If not supplied,
it will attempt to use the option \code{getOption("pubmed.api_key")}.}
}
\value{
A data frame with two columns:
\describe{
  \item{Year}{The publication year (integer).}
  \item{Count}{The number of articles published in that year (integer).}
}
Returns an empty data frame if no valid data is retrieved.
}
\description{
This function queries the NCBI E-utilities API to retrieve the number of PubMed articles
published each year over a specified number of past years for a given search term or package name.
}
\examples{
\dontrun{
get_pubmed_by_year("ggplot2", years_back = 5)
}

}
