% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{cond.true}
\alias{cond.true}
\title{Number of individuals for which the condition is true.}
\format{An object of class \code{numeric} of length 1.}
\usage{
cond.true
}
\description{
\code{cond.true} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the condition is \code{TRUE} (i.e., actually true cases).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{cond.true} individuals depends on the population size \code{\link{N}} and
the condition's prevalence \code{\link{prev}} and is split further into two subsets of
\code{\link{hi}} by the sensitivity \code{\link{sens}} and
\code{\link{mi}} by the miss rate \code{\link{mirt}}.

Perspectives:

\enumerate{
  \item by condition:

The frequency \code{\link{cond.true}} is determined by the population size \code{\link{N}} times the prevalence \code{\link{prev}}:

\code{ \link{cond.true} = \link{N} x \link{prev}}

\item by decision:

a. The frequency \code{\link{hi}} is determined by \code{\link{cond.true}} times the sensitivity \code{\link{sens}}
  (aka. hit rate \code{\link{HR}}):

\code{ \link{hi} = \link{cond.true} x \link{sens}}

b. The frequency \code{\link{mi}} is determined by \code{\link{cond.true}} times the miss rate \code{\link{mirt} = (1 - \link{sens})}:

\code{ \link{mi} = \link{cond.true} x \link{mirt}  =  \link{cond.true} x (1 - \link{sens})}

}

\item to other frequencies:
  In a population of size \code{\link{N}} the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
cond.true <- 1000 * .10   # => sets cond.true to 10\% of 1000 = 100 cases.
is_freq(cond.true)        # => TRUE
is_prob(cond.true)        # => FALSE, as cond.true is no probability (but prev and sens are)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cr}},
  \code{\link{dec.cor}}, \code{\link{dec.err}},
  \code{\link{dec.neg}}, \code{\link{dec.pos}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\keyword{datasets}
