% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_freq}
\alias{is_freq}
\title{Verify that input is a frequency (positive integer value).}
\usage{
is_freq(freq)
}
\arguments{
\item{freq}{A single (typically numeric) argument.}
}
\value{
A Boolean value: \code{TRUE} if \code{freq} is a frequency (positive integer),
otherwise \code{FALSE}.
}
\description{
\code{is_freq} is a function that checks whether its single argument \code{freq}
is a frequency (i.e., a positive numeric integer value).
}
\examples{
# ways to succeed:
is_freq(2)    # => TRUE, but does NOT return the frequency 2.
is_freq(0:3)  # => TRUE (for vector)

## ways to fail:
# is_freq(-1)            # => FALSE + warning (negative values)
# is_freq(1:-1)          # => FALSE (for vector) + warning (negative values)
# is_freq(c(1, 1.5, 2))  # => FALSE (for vector) + warning (non-integer values)

## note:
# is.integer(2)          # => FALSE!

}
\seealso{
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_valid_prob_set}} verifies the validity of probability inputs;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability.

Other verification functions: 
\code{\link{is_complement}()},
\code{\link{is_extreme_prob_set}()},
\code{\link{is_perc}()},
\code{\link{is_prob}()},
\code{\link{is_suff_prob_set}()},
\code{\link{is_valid_prob_pair}()},
\code{\link{is_valid_prob_set}()},
\code{\link{is_valid_prob_triple}()}
}
\concept{verification functions}
