% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/rivervis-package.R
\docType{data}
\name{Ballinderry}
\alias{B.elevation}
\alias{B.reach}
\alias{B.river}
\alias{B.siteaspt}
\alias{B.sitehm}
\alias{B.sitenh4n}
\alias{B.soi}
\alias{B.town}
\alias{Ballinderry}
\alias{fivecolours}
\alias{fivegrades}
\title{Ballinderry River Basin Dataset}
\source{
North Ireland Environment Agency
}
\description{
A ballinderry river basin dataset for demonstrating purposes.
}
\details{
This contains the following 8 datasets and 2 character vectors.
\describe{

\item{B.elevation}{ This dataset can be used to plot elevation
profile of Ballinderry Rivers. It is a data frame with 90 observations on
the following 3 variables.
\describe{
\item{River}{Rivers on which the elevation sites are located}
\item{Distance}{The along-the-river distance between the elevation sites and the mouth of the river.}
\item{Elevation}{A numeric vector of elevation values} } }

\item{B.reach}{ Selected Ballinderry River reaches. It is a data
frame with 1 observation on the following 6 variables.
\describe{
\item{Reach}{Reach names.}
\item{River}{Rivers on which the monitoring sites are located.}
\item{From}{A numeric vector of starting points of reaches.}
\item{To}{A numeric vector of ending points of reaches.}
\item{Group}{A vector of reach group names. This
indicates to which group the reaches belong.}
\item{Style}{A vector
of reach styles and the location of reach lines.} } }

\item{B.river}{ Main rivers and tributaries in Ballinderry Basin for
\code{RiverMap} and \code{RiverLayout}. It is a data frame with 8
observations on the following 5 variables.
\describe{
\item{River}{River names.}
\item{Length}{Length of rivers.}
\item{Position}{Relative relations between rivers and their parent rivers.}
\item{Parent}{Parent rivers.}
\item{Distance}{Distance between the mouths of each river and the
mouths of each river's parent.} } }

\item{B.siteaspt}{
ASPT scores measured in the Ballinderry River Basin in Spring and Autumn, 2009. It is a
data frame with 15 observations on the following 5 variables.
\describe{
\item{Site}{Site ID}
\item{River}{Rivers on which the sites are located}
\item{Distance"}{The along-the-river distance between the
sites and the mouth of the river.}
\item{ASPT_Spring}{ASPT measure in Spring.}
\item{ASPT_Autumn}{ASPT measure in Autumn.}
} }

\item{B.sitehm}{ Selected hydromorphological
results from RHAT. The hydromorphological variables are ordinary factors
which have five grades: High, Good, Moderate, Poor and Bad. It is a data
frame with 17 observations on the following 9 variables.
\describe{
\item{Site}{Monitorings sites.}
\item{River}{Rivers on which the monitoring sites are located.}
\item{Distance}{The along-the-river distance between the sites and the mouth of the river.}
\item{ChanVeg}{Channel vegetation condition.}
\item{ChanFlow}{Channel flow condition.}
\item{BankVegLeft}{Left bank vegetation condition.}
\item{BankVegRight}{Right bank vegetation condition.}
\item{RipLULeft}{Left riparian land-use condition.}
\item{RipLURight}{Right riparian land-use condition.} } }

\item{B.sitenh4n}{
NH4-N values measured in the Ballinderry River Basin in Spring and Autumn, 2009. It is a
data frame with 17 observations on the following 5 variables.
\describe{
\item{Site}{Site ID}
\item{River}{Rivers on which the sites are located}
\item{Distance"}{The along-the-river distance between the
sites and the mouth of the river.}
\item{NH4N_Spring}{NH4-N measure in Spring.}
\item{NH4N_Autumn}{NH4-N measure in Autumn.}
} }

\item{B.soi}{ This dataset provides sites of interest in the Ballinderry River Basin.
The sites have three types: towns, conjunctions of left and right tributaries.
It is a data frame with 5 observations on the following 4 variables.
\describe{
\item{SOI}{Sites of interest.}
\item{River}{Rivers on which the sites are located.}
\item{Distance}{The along-the-river distance
between the sites and the mouth of the river.}
\item{Group}{Groups of the sites.} } }

\item{B.town}{ This dataset provides 2 main towns in the Ballinderry River Basin.
It has the following 4 variables.
\describe{
\item{Town}{Town names.}
\item{River}{Rivers on which the sites are located.}
\item{Distance}{The along-the-river distance between the sites and the mouth of the river.}
\item{Group}{Groups of the sites.} } }

\item{fivegrades}{This vector contains five grades, which are High, Good, Moderate,
Poor and Bad}

\item{fivecolours}{This vector contains five colours representing the five grades.
The five colours are blue(#5381FFFF), green(#7BE859FF), yellow(#FFC944FF),
orange(#E87539FF) and red(#FF3931FF).} }
}
\keyword{datasets}

