% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_dashboard.R
\name{simple_dashboard}
\alias{simple_dashboard}
\title{Compute data for a simple seasonal adjustment}
\usage{
simple_dashboard(x, digits = 2)
}
\arguments{
\item{x}{a seasonal adjustment model made by 'RJDemetra' (object of class \code{"SA"}).}

\item{digits}{number of digits used in the tables.}
}
\description{
Function to compute the data to produce a simple seasonal adjustment dashboard
}
\examples{
data <- window(RJDemetra::ipi_c_eu[, "FR"], start = 2003)
sa_model <- RJDemetra::jx13(data, "RSA5c")
dashboard_data <- simple_dashboard(sa_model)
plot(dashboard_data, main = "Simple dashboard IPI - FR")

}
\seealso{
\code{\link{plot.sc_dashboard}}.
}
