% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_calcs.R
\name{cond_mean}
\alias{cond_mean}
\title{Calculate the mean conditioned on being in a specific model}
\usage{
cond_mean(times, positions, thetas, theta_c, burnin = 1)
}
\arguments{
\item{times}{Vector of event times from the PDMP trajectory}

\item{positions}{Matrix of positions from the PDMP trajectory, each column should correspond to a position}

\item{thetas}{Matrix of PDMP velocities}

\item{theta_c}{Vector indicating the model to condition on, 1s for active variables and zeros for inactive variables}

\item{burnin}{Number of events to use as burnin}
}
\value{
Returns the mean conditioned on being in model theta_c estimated using the PDMP trajectories.
}
\description{
Calculate the mean conditioned on being in a specific model
}
\examples{
generate.logistic.data <- function(beta, n.obs, Sig) {
p <- length(beta)
dataX <- MASS::mvrnorm(n=n.obs,mu=rep(0,p),Sigma=Sig)
vals <- dataX \%*\% as.vector(beta)
generateY <- function(p) { rbinom(1, 1, p)}
dataY <- sapply(1/(1 + exp(-vals)), generateY)
return(list(dataX = dataX, dataY = dataY))
}

n <- 15
p <- 25
beta <- c(1, rep(0, p-1))
Siginv <- diag(1,p,p)
Siginv[1,2] <- Siginv[2,1] <- 0.9
set.seed(1)
data <- generate.logistic.data(beta, n, solve(Siginv))
ppi <- 2/p

zigzag_fit <- zigzag_logit(maxTime = 1, dataX = data$dataX, datay = data$dataY,
                           prior_sigma2 = 10,theta0 = rep(0, p), x0 = rep(0, p), rj_val = 0.6,
                           ppi = ppi)
\dontrun{
b <- cond_mean(zigzag_fit$times, zigzag_fit$positions, zigzag_fit$theta, theta_c = c(1,rep(0,p-1)))
}

}
