% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAOI.R
\name{getAOI}
\alias{getAOI}
\title{Create extent vector for \code{landfireAPI()}}
\usage{
getAOI(data, extend = NULL, sf_order = FALSE)
}
\arguments{
\item{data}{A SpatRaster, SpatVector, sf, stars, or RasterLayer (raster) object}

\item{extend}{Optional. A numeric vector of 1, 2, or 4 elements to
increase the extent by.}

\item{sf_order}{If \code{extend} != NULL, logical indicating that the order of the
\code{extend} vector follows \code{\link[sf:st_bbox]{sf::st_bbox()}} (\code{xmin}, \code{ymin}, \code{xmax}, \code{ymax}) when TRUE or
\code{\link[terra:extend]{terra::extend()}} (\code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}) when FALSE. This
is \code{FALSE} by default to ensure backwards compatibility with previous versions.}
}
\value{
Returns an extent vector ordered \code{xmin}, \code{ymin}, \code{xmax}, \code{ymax}
with a lat/lon projection.
}
\description{
\code{getAOI} creates an extent vector in WGS84 from spatial data
}
\examples{
r <- terra::rast(nrows = 50, ncols = 50,
  xmin = -123.7835, xmax = -123.6352,
  ymin = 41.7534, ymax = 41.8042,
  crs = terra::crs("epsg:4326"),
  vals = rnorm(2500))
ext <- getAOI(r, c(10, 15))

}
