% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo_label}
\alias{quo_label}
\alias{quo_text}
\alias{quo_name}
\title{Format quosures for printing or labelling}
\usage{
quo_label(quo)

quo_text(quo, width = 60L, nlines = Inf)

quo_name(quo)
}
\arguments{
\item{quo}{A quosure or expression.}

\item{width}{Width of each line.}

\item{nlines}{Maximum number of lines to extract.}
}
\description{
These functions take an arbitrary R object, typically an
\link[=is_expression]{expression}, and represent it as a string.
\itemize{
\item \code{quo_name()} returns an abbreviated representation of the object
as a single line string. It is suitable for default names.
\item \code{quo_text()} returns a multiline string. For instance block
expressions like \code{{ foo; bar }} are represented on 4 lines (one
for each symbol, and the curly braces on their own lines).
}

These deparsers are only suitable for creating default names or
printing output at the console. The behaviour of your functions
should not depend on deparsed objects. If you are looking for a way
of transforming symbols to strings, use \code{\link[=as_string]{as_string()}} instead of
\code{quo_name()}. Unlike deparsing, the transformation between symbols
and strings is non-lossy and well defined.
}
\examples{
# Quosures can contain nested quosures:
quo <- quo(foo(!! quo(bar)))
quo

# quo_squash() unwraps all quosures and returns a raw expression:
quo_squash(quo)

# This is used by quo_text() and quo_label():
quo_text(quo)

# Compare to the unwrapped expression:
expr_text(quo)

# quo_name() is helpful when you need really short labels:
quo_name(quo(sym))
quo_name(quo(!! sym))
}
\seealso{
\code{\link[=expr_label]{expr_label()}}, \code{\link[=f_label]{f_label()}}
}
