% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{env_cache}
\alias{env_cache}
\title{Cache a value in an environment}
\usage{
env_cache(env, nm, default)
}
\arguments{
\item{env}{An environment.}

\item{nm}{Name of binding, a string.}

\item{default}{The default value to store in \code{env} if \code{nm} does not
exist yet.}
}
\value{
Either the value of \code{nm} or \code{default} if it did not exist
yet.
}
\description{
\code{env_cache()} is a wrapper around \code{\link[=env_get]{env_get()}} and \code{\link[=env_poke]{env_poke()}}
designed to retrieve a cached value from \code{env}.
\itemize{
\item If the \code{nm} binding exists, it returns its value.
\item Otherwise, it stores the default value in \code{env} and returns that.
}
}
\examples{
e <- env(a = "foo")

# Returns existing binding
env_cache(e, "a", "default")

# Creates a `b` binding and returns its default value
env_cache(e, "b", "default")

# Now `b` is defined
e$b
}
