test_that("MinSpanningTree works", {
  s <- c(1, 1, 2, 3, 4, 4)
  t <- c(2, 3, 3, 4, 1, 2)
  d <- c(1, 10, 3, 2, 0, 8)
  out <- MinSpanningTree(s, t, d, 4)
  expect_equal(out[[1]], c(4, 1, 3))
  expect_equal(out[[2]], c(1, 2, 4))
  expect_equal(out[[3]], 3)
  expect_error(MinSpanningTree(s, t, d, 4, "abc"), "Invalid")
})

test_that("mincostarborescence works", {
  s <- c(1, 2, 3, 4, 5, 6)
  t <- c(2, 3, 4, 5, 6, 1)
  d <- c(1, 10, 3, 2, 0, 8)
  out <- MinCostArborescence(s, t, d, 1, 6)
  expect_equal(out[[1]], c(1, 2, 3, 4, 5))
  expect_equal(out[[2]], c(2, 3, 4, 5, 6))
  expect_equal(out[[3]], 16)
  expect_error(MinCostArborescence(s, t, d, 1, 6, "abc"), "Invalid")
})
