% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestpath.R
\name{ShortestPath}
\alias{ShortestPath}
\title{Solver for Shortest Path Between Two Nodes}
\usage{
ShortestPath(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  sourceNode,
  destNode,
  algorithm = "Suurballe"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{sourceNode}{The start node of the path}

\item{destNode}{The end node of the path}

\item{algorithm}{Choices of algorithm include "Suurballe". "Suurballe" is
the default.}
}
\value{
A list containing two entries: 1) the number of paths from the start
  node to the end node and 2) a list of paths found. If there are multiple
  paths, then the second entry will have multiple paths.
}
\description{
Finds the shortest arc disjoint paths between two nodes in a directed graph.
This implementation runs a variation of the successive shortest path algorithm.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see \url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00609.html}.
}
