% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{covMat.NuggetKriging}
\alias{covMat.NuggetKriging}
\alias{covMat,NuggetKriging,NuggetKriging-method}
\title{Compute Covariance Matrix of NuggetKriging Model}
\usage{
\method{covMat}{NuggetKriging}(object, x1, x2, ...)
}
\arguments{
\item{object}{An S3 NuggetKriging object.}

\item{x1}{Numeric matrix of input points.}

\item{x2}{Numeric matrix of input points.}

\item{...}{Not used.}
}
\value{
A matrix of the covariance matrix of the NuggetKriging model.
}
\description{
Compute Covariance Matrix of NuggetKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- NuggetKriging(y, X, kernel = "gauss")

x1 = runif(10)
x2 = runif(10)

covMat(k, x1, x2)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
