% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotSpatial2D}
\alias{plotSpatial2D}
\alias{plotSpatial2D.liger}
\alias{plotSpatial2D.ligerSpatialDataset}
\title{Visualize a spatial dataset}
\usage{
plotSpatial2D(object, ...)

\method{plotSpatial2D}{liger}(object, dataset, useCluster = NULL, legendColorTitle = NULL, ...)

\method{plotSpatial2D}{ligerSpatialDataset}(
  object,
  useCluster = NULL,
  legendColorTitle = NULL,
  useDims = c(1, 2),
  xlab = NULL,
  ylab = NULL,
  labelText = FALSE,
  ...
)
}
\arguments{
\item{object}{Either a \linkS4class{liger} object containing a spatial
dataset or a \linkS4class{ligerSpatialDataset} object.}

\item{...}{Arguments passed to other methods. \code{.liger} method passes
everything to \code{.ligerSpatialDataset} method, and the latter passes
everything to \code{\link{.ggScatter}} and then
\code{\link{.ggplotLigerTheme}}.}

\item{dataset}{Name of one spatial dataset.}

\item{useCluster}{Either the name of one variable in \code{cellMeta(object)}
or a factor object with annotation that matches with all cells in the
specified dataset. Default \code{NULL} uses default clusters.}

\item{legendColorTitle}{Alternative title text in the legend. Default
\code{NULL} uses the variable name set by \code{useCluster}, or
\code{"Annotation"} is \code{useCluster} is a customized factor object.}

\item{useDims}{Numeric vector of two, choosing the coordinates to be drawn
on 2D space. (STARmap data could have 3 dimensions.) Default \code{c(1, 2)}.}

\item{xlab, ylab}{Text label on x-/y-axis. Default \code{NULL} does not show
it.}

\item{labelText}{Logical, whether to label annotation onto the scatter plot.
Default \code{FALSE}.}
}
\value{
A ggplot object
}
\description{
Visualize a spatial dataset
}
\examples{
ctrl.fake.spatial <- as.ligerDataset(dataset(pbmc, "ctrl"), modal = "spatial")
fake.coords <- matrix(rnorm(2 * ncol(ctrl.fake.spatial)), ncol = 2)
dimnames(fake.coords) <- list(colnames(ctrl.fake.spatial), c("x", "y"))
coordinate(ctrl.fake.spatial) <- fake.coords
dataset(pbmc, "ctrl") <- ctrl.fake.spatial
plotSpatial2D(pbmc, dataset = "ctrl")
}
