% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DESeq2Fit.R
\name{DESeq2Fit}
\alias{DESeq2Fit}
\title{Analysis of LPS RFI RNA-seq data Using DESeq2}
\usage{
DESeq2Fit(counts, design, Effect)
}
\arguments{
\item{counts}{a  matrix of count data.}

\item{design}{a design matrix.}

\item{Effect}{the effect used to simulate data, either line2,  or
 time. This  effect is considered as the main factor of interest where the
 status of DE and EE genes was specified.
@param covset a data frame contain covariate set.}
}
\value{
a list of 4 components
\item{fit}{output of \code{\link[DESeq2]{DESeq}} function.}
\item{pv}{a vector of p-values of the test for significant of \code{Effect}.}
\item{qv}{a vector of q-values corresponding to the \code{pv} above.}
}
\description{
This function analyzes the LPS RFI RNA-seq data and simulated datasets using
\code{\link[DESeq2]{DESeq}}, the Quasi-likelihood F-test in \code{DESeq2}
package.
}
\examples{
\donttest{
data(dat)
data(design)
counts <- dat[1:100,]
design <- design
Effect <- "line2"
DESeq2Fitout <- rmRNAseq:::DESeq2Fit(counts, design, Effect)
names(DESeq2Fitout)
}
}
