% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{TC_CAR1}
\alias{TC_CAR1}
\title{RNA-seq Analysis for Repeated-measures Data}
\usage{
TC_CAR1(counts, design, Subject, Time, C.matrix, Nboot = 100,
  ncores = 1, print.progress = FALSE, saveboot = FALSE)
}
\arguments{
\item{counts}{a matrix of RNA-seq counts.}

\item{design}{a design matrix.}

\item{Subject}{a vector of subjects or experimental units.}

\item{Time}{a vector of time points.}

\item{C.matrix}{is a list of matrix Ci in testing H0:  Ci*beta = 0.}

\item{Nboot}{number of bootstrap replicates, default is 100.}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}

\item{print.progress}{logical indicator, TRUE or FALSE, to print the progress.}

\item{saveboot}{TRUE or FALSE to save or not save bootstrap output}
}
\value{
a list of 3 components \item{ori.res}{a list of 2 components
  \code{v}: voom's output, \code{newlm}: output from \code{\link{voomgls_CAR1}}.}
  \item{boot.res}{a list of \code{Nboot} components, each component is the
  output of \code{\link{voomgls_CAR1}} when apply this function to the
  corresponding bootstrap sample.} \item{pqvalue}{a list 2 components:
  \code{pv}: a matrix of p-values of the tests construted in C.matrix
  \code{qv}: matrix of q-values obtaining from using Nettleton 2006 paper
  approach, using \code{\link{jabes.q}} function.}
}
\description{
This function implements our  parametric bootstrap to analyze
repeated measures RNA-seq data.
}
\examples{
# This example shows how to implement the method using LPS RFI data.
data(dat)
data(design)
data(covset)
Subject <- covset$ear
Time <- covset$time
Nboot <- 2  # for real data analysis, use Nboot at least 100
ncores <- 1 # for real data analysis and if the computer allows, increase ncores to save time
print.progress <- FALSE
saveboot <- FALSE
counts <- dat[1:3,]
C.matrix <- list()
# test for Line main effect
C.matrix[[1]] <- limma::makeContrasts(line2, levels = design)
# test for Time main effect
C.matrix[[2]] <- limma::makeContrasts(time2, time6, time24, levels = design)
names(C.matrix) <- c("line2", "time")
TCout <- rmRNAseq:::TC_CAR1(counts, design, Subject, Time, C.matrix,
Nboot, ncores, print.progress, saveboot)
names(TCout)
TCout$pqvalue$pv
TCout$pqvalue$qv

}
\references{
Yet Nguyen, Dan Nettleton, 2019. rmRNAseq: RNA-seq Analysis for Repeated-measures Data.
}
